# 画面設計書 5-404ページ (Not Found)

## 概要

App Routerにおいてセグメントレベルでページが見つからない場合に表示されるデフォルトの404エラーフォールバックの設計書。`notFound()`関数呼び出し時にも表示される。

### 本画面の処理概要

**業務上の目的・背景**：App Routerでは、ルートセグメント単位でページの有無を判定する。特定のセグメントでページが見つからない場合や、開発者がServer Component/Route Handler内で`notFound()`関数を明示的に呼び出した場合に、本コンポーネントが404エラーフォールバックとして表示される。グローバル404ページ（No.4）とは異なり、html/bodyタグを含まないセグメントレベルのフォールバックであり、親レイアウトの中に埋め込まれて表示される。

**画面へのアクセス方法**：以下の2つのケースで表示される。(1) App Routerのルーティングでセグメントレベルでページが見つからなかった場合。(2) Server ComponentまたはRoute Handler内で`notFound()`関数が呼び出された場合。ユーザーがセグメントレベルの`not-found.tsx`を作成している場合はそちらが優先される。

**主要な操作・処理内容**：
1. `HTTPAccessErrorFallback`コンポーネントにstatus=404とmessage="This page could not be found."を渡して表示する
2. HTTPAccessErrorFallbackコンポーネントが、ステータスコードとメッセージを中央配置で表示する
3. ダークモード対応のCSSが自動適用される

**画面遷移**：
- 遷移元：App Routerのセグメント単位ルーティングでnotFound()呼び出し時、またはセグメントでページが見つからなかった場合
- 遷移先：特になし（エラー表示のみ）

**権限による表示制御**：権限による表示制御は行わない。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 16 | エラーハンドリング | 主機能 | セグメントレベルでのページ未発見時の404エラーフォールバック表示 |
| 13 | App Router | 補助機能 | App Routerのセグメント単位ルーティングでのnotFound()呼び出し連携 |

## 画面種別

エラー表示（404フォールバック / セグメントレベル）

## URL/ルーティング

特定のURLパターンは持たない。セグメントレベルでページが見つからなかった場合、該当URLのまま404ステータスで表示される。

## 入出力項目

| 項目名 | 入出力 | 型 | 必須 | 説明 |
|--------|--------|------|------|------|
| なし | - | - | - | 本コンポーネントはプロパティを受け取らない |

## 表示項目

| 項目名 | 表示位置 | 説明 |
|--------|----------|------|
| ステータスコード | h1要素（左側） | 「404」を表示 |
| エラーメッセージ | h2要素（右側） | 「This page could not be found.」を表示 |
| ページタイトル | titleタグ | 「404: This page could not be found.」 |

## イベント仕様

### 1-なし

本画面にはユーザー操作可能なインタラクティブ要素は存在しない。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| なし | - | - | 本画面はデータベースへのアクセスを行わない |

### テーブル別更新項目詳細

データベース操作なし。

## メッセージ仕様

| メッセージID | 種別 | 条件 | メッセージ内容 |
|-------------|------|------|----------------|
| MSG-404 | エラー | 常時表示 | This page could not be found. |

## 例外処理

| 例外条件 | 挙動 |
|----------|------|
| なし | 本コンポーネントは常に同一の404エラー表示を行う |

## 備考

- App Routerで使用される
- グローバル404ページ（No.4）とは異なり、html/bodyタグを含まない。親レイアウト内に埋め込まれて表示される
- `HTTPAccessErrorFallback`コンポーネントを共有しており、403ページ（No.8）、401ページ（No.9）、グローバル404ページ（No.4）と同じ表示パターンを使用
- ユーザーがセグメントレベルの`not-found.tsx`を作成することでカスタマイズ可能
- `notFound()`関数はServer ComponentやRoute Handlerから呼び出される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | error-fallback.tsx | `packages/next/src/client/components/http-access-fallback/error-fallback.tsx` | L3-8: HTTPAccessErrorFallbackのプロパティ型 |

**読解のコツ**: No.4のグローバル404ページと同じHTTPAccessErrorFallbackを使用するが、html/bodyタグのラッパーが無い点が唯一の違い。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | not-found.tsx | `packages/next/src/client/components/builtin/not-found.tsx` | L1-10: NotFound関数コンポーネント全体 |

**主要処理フロー**:
1. **L1**: `HTTPAccessErrorFallback`をインポート
2. **L3**: `NotFound`関数コンポーネントの定義（default export）
3. **L5-8**: `HTTPAccessErrorFallback`にstatus=404、message="This page could not be found."を渡してレンダリング

#### Step 3: HTTPAccessErrorFallbackコンポーネントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | error-fallback.tsx | `packages/next/src/client/components/http-access-fallback/error-fallback.tsx` | L3-45: 表示ロジック全体 |
| 3-2 | access-error-styles.ts | `packages/next/src/client/components/styles/access-error-styles.ts` | L1-34: 共通スタイル定義 |

### プログラム呼び出し階層図

```
App Router (セグメントレベルのnotFound検出)
    |
    +-- 親レイアウト
            |
            +-- NotFound コンポーネント
                    |
                    +-- HTTPAccessErrorFallback
                            |
                            +-- status=404, message="This page could not be found."
                            +-- access-error-styles (CSS)
                            +-- ダークモードCSS (inline)
```

### データフロー図

```
[入力]               [処理]                           [出力]

(なし) -----------> NotFound() -----------------> ReactElement
                    |                              - <title> "404: This page..."
                    +-- HTTPAccessErrorFallback     - <h1> "404"
                        (status=404,               - <h2> "This page could..."
                         message="This page...")   - inline CSS (dark mode)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| not-found.tsx | `packages/next/src/client/components/builtin/not-found.tsx` | ソース | セグメントレベル404ページのメインコンポーネント |
| error-fallback.tsx | `packages/next/src/client/components/http-access-fallback/error-fallback.tsx` | ソース | HTTP Access Errorのフォールバック表示コンポーネント |
| access-error-styles.ts | `packages/next/src/client/components/styles/access-error-styles.ts` | ソース | Access Errorページの共通スタイル定義 |
